<?php

$this->pageTitle = Yii::app()->name.' - Panel administratora';

$this->breadcrumbs = array(
	'Strona główna'=>array('main/index'),
	'Szkoły',
);

?>
<h1>Szkoły</h1>

<?php if(Yii::app()->user->hasFlash('schoolUpdated')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('schoolUpdated') ?>
	</div>
<?php endif; ?>

<?php if(Yii::app()->user->hasFlash('schoolCreated')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('schoolCreated') ?>
	</div>
<?php endif; ?>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('create') ?>">Dodaj nową szkołę</a>

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'name'=>'nazwa',
			'value'=>'CHtml::link($data->nazwa, array("klasa/admin", "schoolId"=>$data->id))',
			'type'=>'raw',
		),
		'miasto',
		array(
			'class'=>'CButtonColumn',
			'header'=>'',
			'template'=>'{update}{delete}'
		)
	),
));

?>

